//*************************************************************************************************
//
//	Description:
//		shadowgen.fx - Default shader for shadow gen mode rendering.
//
//	<P> Copyright (c) 2007 Blimey! Games Ltd. All rights reserved.
//
//	Author: 
//		Tom Nettleship
//
//	History:
//
//	<TABLE>
//		\Author         Date        Version       Description
//		--------        -----       --------      ------------
//		TNettleship     04/24/2007  0.1           Created
//	<TABLE>
//
//*************************************************************************************************

#include "stddefs.fxh"



//-----------------------------------------------------------------------
// Temporary Shader Code Wrappers
//
// These can be removed once we have support for multiple shaders
//-----------------------------------------------------------------------

	#define		TEMP_VS_SHADOW_WRAPPER_BEGIN			if (cRenderingShadowBuffer == false){
	#define		TEMP_VS_SHADOW_WRAPPER_END				} else { _output.position = mul( float4( _input.position, 1.0f ), worldviewproj ); _output.shadowCoord0 = _output.position; }

#define		TEMP_VS_SHADOW_GENCOORDS(_a,_b)		_a = mul( float4( _b, 1.0f ), cShadowMatrices[3] );
//	#define		TEMP_VS_SHADOW_GENCOORDS(_a,_b)		_a = float4( _b, 1.0f );

	#define		TEMP_PS_SHADOW_WRAPPER_BEGIN	if (cRenderingShadowBuffer == false){
	#define		TEMP_PS_SHADOW_WRAPPER_END		} else { _output.Colour = _input.shadowCoord0.z / _input.shadowCoord0.w; }



//-----------------------------------------------------------------------
//
// Input parameters
//

#if defined( _3DSMAX_ ) || defined(USE_WVP_CONSTANT)
// Max doesn't support viewproj as an app-supplied parameter
float4x4 worldviewproj : WorldViewProjection
<
	string UIWidget = "None";
	bool appEdit = false;
	bool export = false;
>;
#else
SHARE_PARAM float4x4 viewproj : ViewProjection
<
	bool appEdit = false;
	bool export = false;
>;
#endif

float4x4 world : World
<
	string UIWidget = "None";
	bool appEdit = false;
	bool export = false;
	bool dynamic = true;
>;


//-----------------------------------------------------------------------
//
// Vertex Shader
//

// Input structure
struct VSINPUT
{
	float3 position : POSITION;
};


// Output structure
struct VSOUTPUT
{
	float4 position		: POSITION;
#ifdef NEEDS_SHADOW_COORDS
	float4 shadowCoord	: TEXCOORD0;
#endif
};


VSOUTPUT ShadowGenVertexShader( VSINPUT _input )
{
	VSOUTPUT _output;

#if !defined( _3DSMAX_ ) && !defined(USE_WVP_CONSTANT)
	float4x4	worldviewproj = mul( world, viewproj );
#endif

	// Calculate clip-space position of the vertex
	_output.position = mul( float4( _input.position, 1.0f ), worldviewproj );

	// Clamp geometry that is behind the camera to the near plane so that it still renders.
	// We use an orthogonal projection, so doing this will not distort the shadow caster.

	CLAMP_SHADOW_Z;

#ifdef NEEDS_SHADOW_COORDS
	OUTPUT_SHADOW_COORDS;
#endif

	return _output;
}



//-----------------------------------------------------------------------
//
// Fragment Shader
//

// Input structure

#ifdef _PS3_
float4 ShadowGenFragmentShader( void ) : COLOR0
{
	return 0;
}
#else
struct PSINPUT
{
	float4 shadowCoord	: TEXCOORD0;
};

struct PSOUTPUT
{
	COLOUR_OUTPUT_TYPE Colour : COLOR0;
};

PSOUTPUT ShadowGenFragmentShader( PSINPUT _input )
{
	PSOUTPUT output;
	
	CALC_SHADOWMAP_DEPTH( output.Colour, _input.shadowCoord );

	return output;
}
#endif



//-----------------------------------------------------------------------
//
// Technique(s)
//

technique ShadowGen
<
	bool supportsSpecialisedLighting = true;
	bool preservesGlobalState = true;
	string shadowGenBehaviour		= "ERMB_RENDER";
	string shadowGenTechnique		= "ShadowGen";
	int    shadowGenDeferredID	= 0;
>
{
	pass Pass0
	{
		#if !defined(_XBOX)
		ZEnable = true;
		ZWriteEnable = true;
		AlphaBlendEnable = false;
		#endif
		
		AlphaTestEnable = false;

#if defined (_PS3_)
		VertexShader = compile sce_vp_rsx ShadowGenVertexShader();
		PixelShader = compile sce_fp_rsx ShadowGenFragmentShader();
#elif defined(_XBOX) && !defined(SHADOWMAP_COLOUR)
		VertexShader = compile vs_3_0 ShadowGenVertexShader();
		PixelShader = null;
#else
		VertexShader = compile vs_3_0 ShadowGenVertexShader();
		PixelShader = compile ps_3_0 ShadowGenFragmentShader();
#endif
	}
}
